var _isEPub = false;
var _isApp = false;

var __base64Images = [];
__base64Images["./pochodna2.png"]="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADcAAAA8BAMAAAAwMj+2AAAAMFBMVEWAAP+AAP+AAP+AAP/8/fyAAP+AAP+AAP8AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADfTW6sAAAAAXRSTlMAQObYZgAAAAlwSFlzAAAOwwAADsMBx2+oZAAAAaRJREFUOI21lE1zgjAQhvEDvErFO2LaXnFq7bWEBa4MxfbKMCpXGKn+/W4SnIIknnSHSQaeSfK+y2Y1UMendgdIiRp6bsqm2bYyf396K7OajSF+CCc9WPJtQx2HUw/GfIzYqvwa0hGfAkMiyPHEV3vch1VxHApZa/Cu4H4Hwgm4NZy7MMQtS0vIquZGF9poMeZOqAY06UJ0QXX+7qHmugNZRnyRlWAAdNeBPp4ybZwM/50IGAyBvgt/GdPsdaABS3vN30t24KYNI71IMpHsGA/0045ad8Iyg5Ln2uYw05hjSg4NpPzBcHjwnCXPtbKGgnWUKuEnCdQr52ATJfyAlbpuvwpLCWmSqyveY7ZVkP1hJTSfbkAeDO63iogRLkxFTO9xeR8JC1H4ctgUvgJObkDPuAGDsRJS0hS+BIbmeZofDfAHEvhGIo1gI4pHfRikvEWVr9auD10Ui06yleRM1jXwpoKdSiBzwe5uIIPYNWlct29+u2taELkopRrI4Qk1RfkISH9bY2npL6czxIu+lUj7prqj1VBeWljbp8Me59IB4HEF9gf4/a7LQBeV5wAAAABJRU5ErkJggg==";
__base64Images["./kulka.png"]="data:image/png;base64,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";
